/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.capabilities.horseowner;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;

public class HorseOwner
implements IHorseOwner {
    private int horseNum = 0;
    private CompoundNBT horseNBT = new CompoundNBT();
    private String storageUUID = "";
    private RegistryKey<World> lastSeenDim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("overworld"));
    private Vector3d lastSeenPos = Vector3d.field_186680_a;

    @Override
    public AbstractHorseEntity createHorseEntity(World world) {
        Optional type = EntityType.func_220347_a((CompoundNBT)this.horseNBT);
        if (type.isPresent()) {
            Entity entity = ((EntityType)type.get()).func_200721_a(world);
            if (entity instanceof AbstractHorseEntity) {
                entity.func_70020_e(this.horseNBT);
                ++this.horseNum;
                LazyOptional cap = entity.getCapability(HorseProvider.HORSE_CAPABILITY, null);
                if (cap.isPresent()) {
                    ((IStoredHorse)cap.resolve().get()).setHorseNum(this.horseNum);
                    entity.func_184221_a(UUID.randomUUID());
                    entity.func_70066_B();
                    ((AbstractHorseEntity)entity).field_70737_aN = 0;
                }
                return (AbstractHorseEntity)entity;
            }
            CallableHorses.LOGGER.error("The entity with NBT " + this.horseNBT.toString() + " wasn't a horse somehow?...");
        }
        return null;
    }

    @Override
    public CompoundNBT getHorseNBT() {
        return this.horseNBT;
    }

    @Override
    public void setHorse(AbstractHorseEntity horse, PlayerEntity player) {
        this.storageUUID = UUID.randomUUID().toString();
        LazyOptional cap = horse.getCapability(HorseProvider.HORSE_CAPABILITY, null);
        cap.ifPresent(storedHorse -> {
            CompoundNBT tag;
            storedHorse.setHorseNum(this.horseNum);
            storedHorse.setOwned(true);
            storedHorse.setOwnerUUID(player.func_146103_bH().getId().toString());
            storedHorse.setStorageUUID(this.storageUUID);
            this.horseNBT = tag = horse.serializeNBT();
        });
    }

    @Override
    public void clearHorse() {
        this.horseNum = 0;
        this.horseNBT = new CompoundNBT();
        this.storageUUID = "";
        this.lastSeenDim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("overworld"));
        this.lastSeenPos = Vector3d.field_186680_a;
    }

    @Override
    public int getHorseNum() {
        return this.horseNum;
    }

    @Override
    public void setHorseNum(int num) {
        this.horseNum = num;
    }

    @Override
    public String getStorageUUID() {
        return this.storageUUID;
    }

    @Override
    public void setStorageUUID(String id) {
        this.storageUUID = id;
    }

    @Override
    public void setHorseNBT(CompoundNBT nbt) {
        this.horseNBT = nbt;
    }

    @Override
    public void setLastSeenPosition(Vector3d pos) {
        this.lastSeenPos = pos;
    }

    @Override
    public Vector3d getLastSeenPosition() {
        return this.lastSeenPos;
    }

    @Override
    public RegistryKey<World> getLastSeenDim() {
        return this.lastSeenDim;
    }

    @Override
    public void setLastSeenDim(RegistryKey<World> dim) {
        this.lastSeenDim = dim;
    }
}

